#!/bin/bash 

batch_size=256
label_smooth=0.1
python=train_ts.py
workers=16

day=May22
ver=qsb_net_large_se2
seed_array=(
42
)

echo "batch_size: ${batch_size}"
echo "day: ${day}"
echo "label_smooth: ${label_smooth}"
echo "ver: ${ver}"
echo "python: ${python}"
echo "workers: ${workers}"

data=$(date +%Y)-$(date +%m)-$(date +%d)--$(date +%H)-$(date +%M)
mkdir ./results/$data
cp ./*.sh ./*.py ./*.pth.tar ./results/$data

for seed in ${seed_array[*]}
do 
  pretrained_1_32=./results/$data/checkpoint_1_32_${day}_2024${ver}_seeds${seed}.pth.tar

  epochs1=256
  epochs2=256
  
  iter1=( 1 32 0.001  ${epochs1} 0.00001 lambda adam )
  iter2=( 1 1  0.001  ${epochs2} 0.00000 lambda adam ${pretrained_1_32} )

  mode_array=( 
  iter1
  iter2
  )

  for arr in ${mode_array[*]}
  do
    row="$arr[*]"
    mode=(${!row})
    echo "##Start########################################################Start##"
    echo "######################################################################"
    rm -rf ./results/$data/checkpoint_${mode[0]}_${mode[1]}_${day}_2024${ver}_seeds${seed}.pth.tar
    rm -rf ./results/$data/model_best_${mode[0]}_${mode[1]}_${day}_2024${ver}_seeds${seed}.pth.tar
    if [ ${#mode[@]} -eq 7 ];
    then
      echo "${day}, 2024: --a_bits=${mode[0]}, --w_bits=${mode[1]}, --learning_rate=${mode[2]}, --epochs=${mode[3]}, --weight_decay=${mode[4]}" 
      echo " --scheduler=${mode[5]}, --optimizer=${mode[6]}"
      echo " --data=./data, --workers=${workers}, --batch_size=${batch_size}, --seed=${seed}, --momentum=0.9, --label_smooth=${label_smooth}" 
      CUDA_VISIBLE_DEVICES=0,1 python3 ${python} --a_bits=${mode[0]} --w_bits=${mode[1]} --learning_rate=${mode[2]} --epochs=${mode[3]} --weight_decay=${mode[4]} \
                        --scheduler=${mode[5]} --optimizer=${mode[6]} \
                        --label_smooth=${label_smooth} --data=./data --workers=${workers} --batch_size=${batch_size} --seed=${seed} --momentum=0.9 \
                        --outputfile=./results/$data/${mode[0]}_${mode[1]}_training_${day}_2024${ver}_${arr}_seeds${seed}.out --save=./results/$data --board=./results/$data/board\
                       | tee -a ./results/$data/${mode[0]}_${mode[1]}_training_${day}_2024${ver}_${arr}_seeds${seed}.txt
      echo "${day}, 2024: --a_bits=${mode[0]}, --w_bits=${mode[1]}, --learning_rate=${mode[2]}, --epochs=${mode[3]}, --weight_decay=${mode[4]}" 
      echo " --scheduler=${mode[5]}, --optimizer=${mode[6]}"
      echo " --data=./data, --workers=${workers}, --batch_size=${batch_size}, --seed=${seed}, --momentum=0.9, --label_smooth=${label_smooth}" 
    else
      echo "${day}, 2024: --a_bits=${mode[0]}, --w_bits=${mode[1]}, --learning_rate=${mode[2]}, --epochs=${mode[3]}, --weight_decay=${mode[4]}" 
      echo " --scheduler=${mode[5]}, --optimizer=${mode[6]}, --pretrained=${mode[7]}, "
      echo " --data=./data, --workers=${workers}, --batch_size=${batch_size}, --seed=${seed}, --momentum=0.9, --label_smooth=${label_smooth}" 
      CUDA_VISIBLE_DEVICES=0,1 python3 ${python} --a_bits=${mode[0]} --w_bits=${mode[1]} --learning_rate=${mode[2]} --epochs=${mode[3]} --weight_decay=${mode[4]} \
                        --scheduler=${mode[5]} --optimizer=${mode[6]} --pretrained=${mode[7]} \
                        --label_smooth=${label_smooth} --data=./data --workers=${workers} --batch_size=${batch_size} --seed=${seed} --momentum=0.9 \
                        --outputfile=./results/$data/${mode[0]}_${mode[1]}_training_${day}_2024${ver}_${arr}_seeds${seed}.out --save=./results/$data --board=./results/$data/board\
                       | tee -a ./results/$data/${mode[0]}_${mode[1]}_training_${day}_2024${ver}_${arr}_seeds${seed}.txt
      echo "${day}, 2024: --a_bits=${mode[0]}, --w_bits=${mode[1]}, --learning_rate=${mode[2]}, --epochs=${mode[3]}, --weight_decay=${mode[4]}" 
      echo " --scheduler=${mode[5]}, --optimizer=${mode[6]}, --pretrained=${mode[7]}, "
      echo " --data=./data, --workers=${workers}, --batch_size=${batch_size}, --seed=${seed}, --momentum=0.9, --label_smooth=${label_smooth}" 
    fi
    mv  ./results/$data/checkpoint.pth.tar ./results/$data/checkpoint_${mode[0]}_${mode[1]}_${day}_2024${ver}_seeds${seed}.pth.tar
    mv  ./results/$data/model_best.pth.tar ./results/$data/model_best_${mode[0]}_${mode[1]}_${day}_2024${ver}_seeds${seed}.pth.tar
    echo "######################################################################"
    echo "##End############################################################End##"
    echo " "
    echo " "
  done
done

